// boxcar_128.v
// Performs a single stage CIC filter of length n = 128 on bit stream (18 bits)
// DJS 8/11/16

module boxcar_128 (
	input wire clk,
	input wire [17:0] din,   // 18-bit conversion result
	output reg [17:0] dout   // 18-bit conversion result
);

reg [2321:0] shift_reg;
reg [24:0] sum_reg;

initial 
begin
  shift_reg = 0;
  sum_reg = 0;
end

//load the shift register & update sum
always @ (posedge clk)
begin
	shift_reg = shift_reg << 18;
	shift_reg[17:0] = din;
	sum_reg = sum_reg + {{7{shift_reg[17]}},shift_reg[17:0]} - {{7{shift_reg[2321]}},shift_reg[2321:2304]};  
end

//scale the output to 18 bits
always @ (negedge clk)
	dout = {{7{sum_reg[24]}},sum_reg[24:7]};

endmodule